"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Fs = require('fs');
const Path = require('path');
/**
 * 文件工具
 */
class FileUtil {
    /**
     * 复制文件/文件夹
     * @param {Fs.PathLike} srcPath 源路径
     * @param {Fs.PathLike} destPath 目标路径
     */
    static copy(srcPath, destPath) {
        if (!Fs.existsSync(srcPath))
            return;
        const stats = Fs.statSync(srcPath);
        if (stats.isDirectory()) {
            if (!Fs.existsSync(destPath))
                Fs.mkdirSync(destPath);
            const names = Fs.readdirSync(srcPath);
            for (const name of names) {
                this.copy(Path.join(srcPath, name), Path.join(destPath, name));
            }
        }
        else if (stats.isFile()) {
            Fs.writeFileSync(destPath, Fs.readFileSync(srcPath));
        }
    }
    /**
     * 删除文件/文件夹
     * @param {Fs.PathLike} path 路径
     */
    static delete(path) {
        if (!Fs.existsSync(path))
            return;
        const stats = Fs.statSync(path);
        if (stats.isDirectory()) {
            const names = Fs.readdirSync(path);
            for (const name of names) {
                this.delete(Path.join(path, name));
            }
            Fs.rmdirSync(path);
        }
        else if (stats.isFile()) {
            Fs.unlinkSync(path);
        }
    }
    /**
     * 遍历文件/文件夹并执行函数
     * @param {Fs.PathLike} path 路径
     * @param {(filePath: Fs.PathLike, stat: Fs.Stats) => void} handler 处理函数
     */
    static map(path, handler) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!Fs.existsSync(path))
                return;
            const stats = Fs.statSync(path);
            if (stats.isDirectory()) {
                const names = Fs.readdirSync(path);
                for (const name of names) {
                    yield this.map(Path.join(path, name), handler);
                }
            }
            else if (stats.isFile()) {
                yield handler(path, stats);
            }
        });
    }
}
exports.default = FileUtil;
