const { h } = require("vue");

module.exports = Editor.Panel.define({
    template: `<div id="app">
		<div style="display:flex">
			<button onclick="startCheck()">全文检索</button>
			<label class="checkbox-label" style="display:flex; align-items:center; margin-left:20px;">
				<input type="checkbox" onclick="updateFilter()" id="includePrefab" checked />包含预制体
			</label>
			
			<label class="checkbox-label" style="display:flex; align-items:center; margin-left:20px;">
				<input type="checkbox" onclick="updateFilter()" id="includeScene" checked />包含场景
			</label>
		</div>
		<hr>
		<div id='list'></div>
	</div>`,

	style:`

	
		#app{
			background:#2b2b2b;
			color:white;
			padding:10px 10px;
			user-select: text;
			overflow-y: auto;
			height:calc(100vh - 40px);
		}

		.tb{
			background: white;
			width:100%;
			border-spacing:1px;
			margin-top:10px;
		}

		.tr{

		}

		.td{
			background: #2b2b2b;
			padding:4px 10px;
			color:white;
		}

		.link{
			color: #a0a0ff;
			text-decoration:underline;
			cursor:pointer;

		}

		.checkbox-label{
			user-select: none;
			cursor:pointer;
		}
	`,
    $: {
        app: '#app',
    },
    methods: {
        init() { 
			window.foucsAndOpenInAssets = this.foucsAndOpenInAssets.bind(this);
			window.startCheck = this.startCheck.bind(this);
			window.updateFilter = this.updateFilter.bind(this);
		},
		
		startCheck(){
			Editor.Message.send('references-finder', 'findUnuse');
		},

		updateFilter(){
			if(this.cacheData){
				this.showUnuseData(this.cacheData);
			}
		},

		showProcess(json){
			const {current, total, path} = json;
			let htmlText = `<div style="padding:10px">正在扫描资源：${current}/${total}<br>当前资源路径：${path}</div>`;
			this.$.app.querySelector('#list').innerHTML = htmlText;
		},

		foucsAndOpenInAssets( value, uuid){
			Editor.Message.request('references-finder', 'foucsAndOpenInAssets', {value, uuid})
		},

		showUnuseData(json){

			this.cacheData = json;
			const {rs, types} = json;

			const data = rs;

			let includePrefab = this.$.app.querySelector('#includePrefab').checked;
			let includeScene = this.$.app.querySelector('#includeScene').checked;
			
			// console.log(data);

			let arr = data.filter(item=>item.useCount <= 0);
			let htmlText = `<div>`;
			for(let key in types){
				htmlText += `<span style="padding-right:10px;">${key}：${types[key]}</span>`;
			}
			htmlText += `</div>`;

			htmlText += '<table class="tb"><tr class="tr"><th class="td">资源路径</th><th class="td">引用次数</th></tr>';
			
			arr.forEach((cfg, index)=>{
				if(!includePrefab && cfg.path.indexOf('.prefab') != -1){
					return;
				}
				if(!includeScene && cfg.path.indexOf('.scene') != -1){
					return;
				}
				htmlText += `<tr class='tr'>
					<td class='td'><span class='link' onclick="foucsAndOpenInAssets('${cfg.path.replace('db://', '')}', '${cfg.uuid}')">${cfg.path}</span></td>
					<td class='td '>${cfg.useCount}</td>
				</tr>`;
			})

			htmlText += '</table>';

			this.$.app.querySelector('#list').innerHTML = htmlText;
		}
    },
    async ready(data) {
        this.init(data)
    }
});