module.exports = Editor.Panel.define({
    template: `<div id="app">
	
	</div>`,

	style:`

		#app{
			background:#2b2b2b;
			color:white;
			padding:10px 10px;
			user-select: text;
			overflow-y: auto;
			height:calc(100vh - 40px);
		}

		.tb{
			background: white;
			width:100%;
			border-spacing:1px;
			margin-top:10px;
		}

		.tr{

		}

		.td{
			background: #2b2b2b;
			padding:4px 10px;
			color:white;
		}

		.link{
			color: #a0a0ff;
			text-decoration:underline;
			cursor:pointer;

		}

		.tooltip {
			position: relative;
			display: inline-block;
			border-bottom: 1px dotted black;
			cursor: pointer;
		}

		.tooltiptext {
			visibility: hidden;
			width: 130px;
			background-color: black;
			color: #fff;
			text-align: center;
			border-radius: 6px;
			padding: 5px 10px;
			position: absolute;
			z-index: 1;
		}

		.tooltip:hover .tooltiptext {
			visibility: visible;
		}
	`,
    $: {
        app: '#app',
    },
    methods: {
        init(data) { 
			this.showData(data);

			window.clickLink = this.clickLink.bind(this);
			window.refreshUUID = this.refreshUUID.bind(this);
		},

		clickLink(isAsset, value, parentKey, uuid, index){
			Editor.Message.request('references-finder', 'clickLink', {isAsset, value, parentKey, uuid, index})
		},

		refreshUUID(uuid){
			Editor.Message.request('references-finder', 'refreshUUID', {uuid})
		},

		showData(json){
			if(!json){
				return;
			}
			let {rs} = json;

			const data = rs;
			let htmlText = ``;
			htmlText += `
				<div>
					<span style="font-weight:bolder">path: ${data.path}</span>
					<span style="font-size:12px;padding-left:20px;">(使用：assets中选中需要查找的资源，按F6)</span>
					</div>
				<div>
					引用次数：${data.useCount} 
					<span class='link' onclick="refreshUUID('${data.uuid}')">[刷新]</span>
					<span style="font-size:12px;padding-left:20px;">(定位：先点击打开场景/prefab，再点击打开对应节点)</span>
				</div>
			`;

			htmlText += '<table class="tb"><tr class="tr"><th class="td">引用资源</th><th class="td">节点路径</th><th class="td">组件 -> 属性</th></tr>';
			
			for(let key in data.tree){
				let cfgs = data.tree[key];

				cfgs.forEach((cfg, index)=>{
					let warning = `<span style="padding-left:10px" class="tooltip">❓<span class="tooltiptext">undefined？这确实是一个BUG，但是不影响节点查找</span></span>`;
					if(cfg.node.indexOf('undefined') == -1){
						warning = '';
					}
					htmlText += `<tr class='tr'>
						<td class='td'><span class='link' onclick="clickLink(true, '${key}', '${data.uuid}', ${index})">${index == 0 ? key:''}</span></td>
						<td class='td'><span class='link' onclick="clickLink(false, '${cfg.node}', '${key}', '${data.uuid}', ${index})">${cfg.node}</span> ${warning}</td>
						<td class='td component'>${cfg.component} -> ${cfg.property}</td>
					</tr>`;
				})
			};

			if(rs.useCount == 0){
				htmlText += `<tr class='tr'>
					<td class='td' colspan="3" style="text-align:center;">没有找到 ${data.path}的引用或者不支持查找该类型的资源</td>
				</tr>`;
			}

			htmlText += '</table>';

			this.$.app.innerHTML = htmlText;
		}
    },
    async ready(data) {
        this.init(data)
    }
});